//=============================================================================
// TRP_CommonEventGroup.js
//=============================================================================
/*:
 * @plugindesc コモンイベントグループ化プラグイン
 * @author Thirop
 *
 * @help
 * 詳しい使い方はマニュアルを参照してください。
 * https://ci-en.net/creator/2170/article/176809
 * 
 * 【更新履歴】
 * 1.00 2020/1/17 初版。
 */
//============================================================================= 

(function(){
'use strict';


//=============================================================================
// GameInterpreter
//=============================================================================
var PLUGIN_COMMANDS = ['commongroup','コモンイベントグループ','コモングループ','コモンイベントセット','コモンセット'];

var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
	_Game_Interpreter_pluginCommand.call(this, command, args);

	if (PLUGIN_COMMANDS.contains(command.toLowerCase())){
		var subCommand = args.shift().toLowerCase();
		if(subCommand==='register'||subCommand==='登録'){
			this.commandRegisterCustomEventGroup(args);
		}else if(subCommand==='start'||subCommand==='開始'||subCommand==='呼び出し'||subCommand==='スタート'){
			this.commandStartCustomEventGroup(args);
		}else if(subCommand==='clear'||subCommand==='クリア'){
			this.commandClearCustomEventGroup(args);
		}
		return;
	}
};

Game_Interpreter.prototype.commandRegisterCustomEventGroup = function(args){
	var nextCode = this.nextEventCode();
	if(nextCode !== 117){
		throw new Error('コモンイベントグループ登録コマンドの直後にコモンイベントコマンドで登録するコモンイベントを指定してください。')
	}

	var groupId = args[0];
	var group = this.commonEventGroupWithNextCommonEventCommand();
	if(!group){
		throw new Error('コモンイベントグループ登録コマンドの直後にコモンイベントコマンドで登録するコモンイベントを指定してください。')
	}

	$gameSystem.registerEventGroup(groupId,group);
};


Game_Interpreter.prototype.commonEventGroupWithNextCommonEventCommand = function(){
	var nextCode = this.nextEventCode();
	if(nextCode !== 117){
		return null;
	}
	var group = [];
    while (this.nextEventCode() === 117) {
        this._index++;
        var params = this.currentCommand().parameters;
        var commonId = params[0];
    	group.push(commonId);
    }
    return group;
};



Game_Interpreter.prototype.commandStartCustomEventGroup = function(args){
	var id = args[0];
	var group;
	if(id){
		group = $gameSystem.commonEventGroup(id);
		if(!group){
			throw new Error('コモンイベントグループID:'+id+'に対応するグループが登録されてません。');
		}
	}else{
		group = this.commonEventGroupWithNextCommonEventCommand();
		if(!group){
			throw new Error('コモンイベントグループの開始コマンドでグループIDを指定しない場合は、直後に複数のコモンイベントコマンドを配置して下さい。');
		}
	}
	var index = Math.randomInt(group.length);
	var commonEvent = $dataCommonEvents[group[index]];

	var eventId = this.isOnCurrentMap() ? this._eventId : 0;
    this.setupChild(commonEvent.list, eventId);
};

Game_Interpreter.prototype.commandClearCustomEventGroup = function(args){
	var id = args[0];
	if(!id || id.toLowerCase()==='all'||id==='全て'||id==='全部'){
		$gameTroop.clearAllEventGroup();
	}else{
		id = Number(id);
		$gameTroop.clearEventGroup(id);
	}
};


//=============================================================================
// Game_System
//=============================================================================
var _Game_System_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function() {
	_Game_System_initialize.call(this);
	this.safeInitEventGroup();
};

Game_System.prototype.safeInitEventGroup = function(){
	if(!this._commonEventGroup){
		this._commonEventGroup = {};
	}
};

Game_System.prototype.registerEventGroup = function(id,group){
	this.safeInitEventGroup();
	this._commonEventGroup[id] = group;
};


Game_System.prototype.commonEventGroup = function(id){
	this.safeInitEventGroup();
	var group = this._commonEventGroup[id];
	return group||null;
};

Game_System.prototype.clearEventGroup = function(id){
	this.safeInitEventGroup();
	delete this._commonEventGroup[id];
};
Game_System.prototype.clearAllEventGroup = function(id){
	this._commonEventGroup = {};
};




})();